#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#define MAXN 200000
#define ITERS 60
#define M_PI 3.14159

long long x[MAXN], y[MAXN];
int best_sel[MAXN], cur_sel[MAXN];

int main() {
    int n;
    scanf("%d", &n);

    for (int i = 0; i < n; i++) {
        scanf("%lld %lld", &x[i], &y[i]);
    }

    srand(time(NULL));

    long long bestX = 0, bestY = 0;
    int bestCnt = 0;

    for (int it = 0; it < ITERS; it++) {
        double ang = ((double)rand() / RAND_MAX) * 2.0 * M_PI;
        double ux = cos(ang);
        double uy = sin(ang);

        long long sx = 0, sy = 0;
        int cnt = 0;

        for (int i = 0; i < n; i++) {
            if (x[i] * ux + y[i] * uy > 0) {
                sx += x[i];
                sy += y[i];
                cur_sel[cnt++] = i;
            }
        }

        if (sx * sx + sy * sy > bestX * bestX + bestY * bestY) {
            bestX = sx;
            bestY = sy;
            bestCnt = cnt;
            for (int i = 0; i < cnt; i++)
                best_sel[i] = cur_sel[i];
        }
    }

    printf("%d\n", bestCnt);
    for (int i = 0; i < bestCnt; i++)
        printf("%d ", best_sel[i] + 1);
    printf("\n");

    return 0;
}